/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.filtering;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterAnd;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterCraftable;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterMod;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOr;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOreDict;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class GridFilterParser {
    public static Predicate<IGridStack> getFilters(@Nullable IGrid grid, String query, List<IFilter<?>> filters) {
        List<Predicate<IGridStack>> gridFilters;
        String[] orParts = query.split("\\|");
        if (orParts.length == 1) {
            gridFilters = GridFilterParser.getFilters(query);
        } else {
            LinkedList<Predicate<IGridStack>> orPartFilters = new LinkedList<Predicate<IGridStack>>();
            for (String orPart : orParts) {
                orPartFilters.add(GridFilterAnd.of(GridFilterParser.getFilters(orPart)));
            }
            gridFilters = new LinkedList<Predicate<IGridStack>>();
            gridFilters.add(GridFilterOr.of(orPartFilters));
        }
        if (grid != null) {
            if (grid.getViewType() == 1) {
                gridFilters.add(new GridFilterCraftable(false));
            } else if (grid.getViewType() == 2) {
                gridFilters.add(new GridFilterCraftable(true));
            }
        }
        if (!filters.isEmpty()) {
            gridFilters.add(new GridFilterFilter(filters));
        }
        return GridFilterAnd.of(gridFilters);
    }

    private static List<Predicate<IGridStack>> getFilters(String query) {
        LinkedList<Predicate<IGridStack>> gridFilters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                gridFilters.add(new GridFilterMod(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                gridFilters.add(new GridFilterTooltip(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                gridFilters.add(new GridFilterOreDict(part.substring(1)));
                continue;
            }
            gridFilters.add(new GridFilterName(part));
        }
        return gridFilters;
    }
}

